unit Frmdemo;

interface

uses
  SysUtils, Classes, Graphics, Controls, Forms,
  StdCtrls, Buttons, ExtCtrls, Dialogs, MsgDlg;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    bShowDlg: TBitBtn;
    bClose: TBitBtn;
    MessageDialog1: TMessageDialog;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    RBConfirmation: TRadioButton;
    RBCustom: TRadioButton;
    RBError: TRadioButton;
    RBInformation: TRadioButton;
    RBWarning: TRadioButton;
    tCaption: TEdit;
    tMessageText: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox3: TGroupBox;
    RBWin31: TRadioButton;
    RBWin95: TRadioButton;
    Panel2: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    cbYes: TCheckBox;
    cbNo: TCheckBox;
    cbOK: TCheckBox;
    cbRetry: TCheckBox;
    cbIgnore: TCheckBox;
    cbCancel: TCheckBox;
    cbAll: TCheckBox;
    cbHelp: TCheckBox;
    cbAbort: TCheckBox;
    GroupBox4: TGroupBox;
    rbBGYes: TRadioButton;
    rbBGNo: TRadioButton;
    GroupBox5: TGroupBox;
    rbCYes: TRadioButton;
    rbCNo: TRadioButton;
    tLeft: TEdit;
    tTop: TEdit;
    Label8: TLabel;
    Label9: TLabel;
    GroupBox6: TGroupBox;
    rbSNone: TRadioButton;
    rbSAsterix: TRadioButton;
    rbSCriticalStop: TRadioButton;
    rbSDefault: TRadioButton;
    rbSQuestion: TRadioButton;
    rbSExclamation: TRadioButton;
    Label10: TLabel;
    RBAutoDetect: TRadioButton;
    GroupBox7: TGroupBox;
    cbDB: TComboBox;
    GroupBox8: TGroupBox;
    rbMCYes: TRadioButton;
    rbMCNo: TRadioButton;
    Label11: TLabel;
    tMinWidth: TEdit;
    Label7: TLabel;
    BitBtn1: TBitBtn;
    GroupBox9: TGroupBox;
    rbFTBYes: TRadioButton;
    rbFTBNo: TRadioButton;
    procedure bShowDlgClick(Sender: TObject);
    procedure bCloseClick(Sender: TObject);
    procedure rbCNoClick(Sender: TObject);
    procedure rbCYesClick(Sender: TObject);
    procedure tLeftKeyPress(Sender: TObject; var Key: Char);
    procedure tMinWidthKeyPress(Sender: TObject; var Key: Char);
    procedure tMinWidthExit(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.bShowDlgClick(Sender: TObject);
var
  Buttons : TMsgDlgButtons;
begin
  { DialogButtons }
  Buttons := [];
  If cbYes.Checked then Buttons := [mbYes];
  If cbNo.Checked then Buttons := Buttons + [mbNo];
  If cbOK.Checked then Buttons := Buttons + [mbOK];
  If cbCancel.Checked then Buttons := Buttons + [mbCancel];
  If cbAbort.Checked then Buttons := Buttons + [mbAbort];
  If cbRetry.Checked then Buttons := Buttons + [mbRetry];
  If cbIgnore.Checked then Buttons := Buttons + [mbIgnore];
  If cbAll.Checked then Buttons := Buttons + [mbAll];
  If cbHelp.Checked then Buttons := Buttons + [mbHelp];

  With MessageDialog1 do Begin
    { Caption }
    Caption := tCaption.text;
    { Text }
    Text := tMessageText.text;
    { DialogType }
    If      RBConfirmation.Checked then DialogType := mtConfirmation
    else if RBCustom.Checked then DialogType := mtCustom
    else if RBError.Checked then DialogType := mtError
    else if RBInformation.Checked then DialogType := mtInformation
    else if RBWarning.Checked then DialogType := mtWarning;
    { DialogStyle }
    If RBAutoDetect.Checked then DialogStyle := dsAutoDetect
    else if RBWin31.Checked then DialogStyle := dsWin31
    else DialogStyle := dsWin95;
    { DialogButtons }
    DialogButtons := Buttons;
    { ButtonGlyphs }
    ButtonGlyphs := rbBGYes.Checked;
    { Centered }
    If rbCYes.Checked then Centered := True
    else Begin
      Centered := False;
      DialogLeft := StrToInt(tLeft.Text);
      DialogTop := StrToInt(tTop.Text);
    End;
    { Sound }
    If rbSNone.Checked then DialogSound := dsNone
    else if rbSAsterix.Checked then DialogSound := dsAsterix
    else if rbSCriticalStop.Checked then DialogSound := dsCriticalStop
    else if rbSDefault.Checked then DialogSound := dsDefault
    else if rbSExclamation.Checked then DialogSound := dsExclamation
    else if rbSQuestion.Checked then DialogSound := dsQuestion;
    { DefaultButton }
    If cbDB.ItemIndex <> -1 then
    Case cbDB.ItemIndex of
      0: DefaultButton := mbYes;
      1: DefaultButton := mbNo;
      2: DefaultButton := mbOk;
      3: DefaultButton := mbCancel;
      4: DefaultButton := mbAbort;
      5: DefaultButton := mbRetry;
      6: DefaultButton := mbIgnore;
      7: DefaultButton := mbAll;
      8: DefaultButton := mbHelp;
    end;
    { MoveCursor }
    MoveCursor := rbMCYes.Checked;
    { MinWidth }
    MinWidth := StrToInt(tMinWidth.Text);
    { Flash TitleBar }
    FlashTitleBar := rbFTBYes.Checked;

    Execute; { Show the Dialog }
  End;

end;

procedure TForm1.bCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.rbCNoClick(Sender: TObject);
begin
  tLeft.Enabled := True;
  tTop.Enabled := True;
end;

procedure TForm1.rbCYesClick(Sender: TObject);
begin
  tLeft.Enabled := False;
  tTop.Enabled := False;
end;

procedure TForm1.tLeftKeyPress(Sender: TObject; var Key: Char);
begin
  If Key = #8 then Exit;
  If (Key < #48) or (Key > #57) then Key := #0;
end;

procedure TForm1.tMinWidthKeyPress(Sender: TObject; var Key: Char);
begin
  If Key = #8 then Exit;
  If (Key < #48) or (Key > #57) then Key := #0;
end;

procedure TForm1.tMinWidthExit(Sender: TObject);
var
  Number: Integer;
begin
  If tMinWidth.Text <> '' then
  begin
    Number := StrToInt(tMinWidth.Text);
    If (Number < 150) or (Number > Screen.Width) then
    begin
      MessageDialog1.MsgDlg('You must enter a number be!!! 150 and '
        + IntToStr(Screen.Width) + '!','I''m Warning You...',
        mtInformation, [mbOk], mbOk, 0);
      tMinWidth.SetFocus;
      tMinWidth.Text := '150';
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  cbDB.ItemIndex := 1;
end;

procedure TForm1.BitBtn1Click(Sender: TObject);
begin
{<<<>>> Declaration of the Function MsgDlg <<<>>>

  function MsgDlg(Const Text, Caption: String; MsgDlgType: TMsgDlgType;
    MsgDlgButtons: TMsgDlgButtons; MsgDlgDefaultButton: TMsgDlgBtn;
    HelpCtx: LongInt): TModalResult;
}

  MessageDialog1.MsgDlg( { Text } 'This Dialog is displayed using the ' +
      'function "MsgDlg". You can use this method to pass at once the ' +
      'Text, Caption, DialogType, DialogButtons, DefaultButton and ' +
      'HelpContext parameters.\n\nCheck out the source code of this ' +
      'button for more information...',
      { Caption } 'Caption', { DialogType } mtInformation,
      { DialogButtons } [mbOk], { DefaultButton } mbOk,{ Context ID } 0);
      { You do not have to use the Execute Method! }
end;

end.
